/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.CommandAction;
import com.quantumdata.busmon.ComponentFactory;
import com.quantumdata.busmon.ExtensionFilter;
import com.quantumdata.busmon.PortAction;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.ToggleAction;
import com.quantumdata.busmon.TraceFileFormatAccessory;
import com.quantumdata.busmon.parser.Packet;
import com.quantumdata.busmon.parser.PacketTrace;
import com.quantumdata.busmon.parser.PacketTraceType;
import com.quantumdata.busmon.parser.Parser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.security.AccessControlException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public final class MainAppFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 41;
    private JMenuBar jMenuBar;
    private JMenu jMenuCEC;
    private JMenu jMenuCECPort;
    private JMenu jMenuDDC;
    private JMenu jMenuDDCPort;
    private JMenu jMenuDisplayPort;
    private JMenu jMenuDisplayPortInterface;
    private JMenu jMenuFile;
    private JMenu jMenuOptions;
    private PacketListListener pl;
    private JMenu jMenuSearch;
    private JTextArea jPacketDetails;
    private JTextArea jPacketRaw;
    public JTable jPacketTable;
    private JScrollPane jScrollDetails;
    private JScrollPane jScrollPaneTable;
    private JScrollPane jScrollRaw;
    private JToolBar jStatusBar;
    private JTextField jTextConnection;
    private JTextField jTextPacketCount;
    private JToolBar jToolBar;
    public static CommandAction connectAction;
    public static CommandAction newAction;
    public static CommandAction openAction;
    public static CommandAction saveAsAction;
    public static CommandAction saveAction;
    public static CommandAction quitAction;
    public static CommandAction findAction;
    public static CommandAction findNextAction;
    public static CommandAction sendCommandAction;
    public static CommandAction aboutAction;
    public static CommandAction colorsAction;
    public static ToggleAction highlightAction;
    public static ToggleAction toggleCaptureAction;
    public static ToggleAction togglePauseAction;
    public static ToggleAction togglePedanticAction;
    public static ToggleAction toggleStateTraceAction;
    public static ToggleAction filterEDIDAction;
    public static ToggleAction filterDDCCIAction;
    public static ToggleAction filterHDCPAction;
    public static ToggleAction filterCECAction;
    public static ToggleAction filterLTAction;
    public static ToggleAction filterEventsAction;
    public static ToggleAction filterOtherAction;
    public static ToggleAction errorsOnlyAction;
    public static ToggleAction deltaTimeAction;
    public static ToggleAction confirmExitAction;
    public static ToggleAction confirmNewAction;
    public static ToggleAction enable5VoltTPAAction;
    public static ToggleAction enableHPDDetectionAction;
    public static ToggleAction enablePrechargeSyncDetectionAction;
    static int selectedRow;
    static JDialog findDialog;
    static JDialog connectDialog;
    static JDialog colorDialog;
    static JDialog sendCommandDialog;
    static File openFile;
    static JFileChooser files;
    public static Vector<PortAction> analyzerDDCPorts;
    public static int analyzerDDCPort;
    public static int numDDCPorts;
    private ButtonGroup buttonGroupDDCPorts;
    public static Vector<PortAction> analyzerCECPorts;
    public static int analyzerCECPort;
    public static int numCECPorts;
    private ButtonGroup buttonGroupCECPorts;
    public static Vector<PortAction> analyzerDisplayPorts;
    public static int analyzerDisplayPort;
    public static int numDisplayPorts;
    private ButtonGroup buttonGroupDisplayPorts;

    public MainAppFrame() {
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.initComponents();
        this.setBounds(0, 0, dimension.width, dimension.height);
        connectAction = new CommandAction("Connect to Instrument...", CommandAction.Command.CONNECT, KeyStroke.getKeyStroke(67, 128), 67);
        newAction = new CommandAction("New Trace", CommandAction.Command.NEW, KeyStroke.getKeyStroke(78, 128), 78);
        openAction = new CommandAction("Open Saved Trace...", CommandAction.Command.OPEN, KeyStroke.getKeyStroke(79, 128), 79);
        saveAsAction = new CommandAction("Save Trace As...", CommandAction.Command.SAVEAS, KeyStroke.getKeyStroke(65, 128), 65);
        saveAction = new CommandAction("Save Trace...", CommandAction.Command.SAVE, KeyStroke.getKeyStroke(83, 128), 83);
        if (Sniffer.program != null) {
            quitAction = new CommandAction("Quit", CommandAction.Command.QUIT, KeyStroke.getKeyStroke(81, 128), 81);
        }
        this.jMenuFile.add(new JMenuItem(connectAction));
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(new JMenuItem(newAction));
        this.jMenuFile.add(new JMenuItem(openAction));
        this.jMenuFile.add(new JMenuItem(saveAction));
        saveAction.setEnabled(false);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(new JMenuItem(quitAction));
        findAction = new CommandAction("Find...", CommandAction.Command.FIND, KeyStroke.getKeyStroke(70, 128), 70);
        findNextAction = new CommandAction("Find Next", CommandAction.Command.FINDNEXT, KeyStroke.getKeyStroke(114, 0), 78);
        this.jMenuSearch.add(new JMenuItem(findAction));
        this.jMenuSearch.add(new JMenuItem(findNextAction));
        sendCommandAction = new CommandAction("Send Command...", CommandAction.Command.SENDCOMMAND);
        sendCommandAction.putValue("MNEMONIC_KEY", 83);
        colorsAction = new CommandAction("Colors...", CommandAction.Command.COLORS);
        colorsAction.putValue("MNEMONIC_KEY", 67);
        confirmExitAction = new ToggleAction("Confirm on Exit", "Confirm on Exit", ToggleAction.Toggle.CONFIRMEXIT);
        confirmExitAction.putValue("MNEMONIC_KEY", 88);
        confirmNewAction = new ToggleAction("Confirm on New Trace", "Confirm on New Trace", ToggleAction.Toggle.CONFIRMNEW);
        confirmNewAction.putValue("MNEMONIC_KEY", 78);
        togglePedanticAction = new ToggleAction("DEBUG: Uber-Pedantic Debug Mode", "DEBUG: Uber-Pedantic Debug Mode", ToggleAction.Toggle.PEDANTIC);
        toggleStateTraceAction = new ToggleAction("DEBUG: Show I2C State Machine Trace", "DEBUG: Show I2C State Machine Trace", ToggleAction.Toggle.STATETRACE);
        aboutAction = new CommandAction("About...", CommandAction.Command.ABOUT);
        aboutAction.putValue("MNEMONIC_KEY", 65);
        toggleCaptureAction = new ToggleAction("Capture", "Stop", ToggleAction.Toggle.CAPTURE, false, MainAppFrame.class.getResource("resources/red-off.gif"), MainAppFrame.class.getResource("resources/red-on.gif"));
        toggleCaptureAction.putValue("MNEMONIC_KEY", 116);
        togglePauseAction = new ToggleAction("Pause", "PAUSED", ToggleAction.Toggle.PAUSE, false, MainAppFrame.class.getResource("resources/yellow-off.gif"), MainAppFrame.class.getResource("resources/yellow-on.gif"));
        filterEDIDAction = new ToggleAction("EDID", "EDID", ToggleAction.Toggle.EDID, true, MainAppFrame.class.getResource("resources/unchecked.jpg"), MainAppFrame.class.getResource("resources/checked.jpg"));
        filterDDCCIAction = new ToggleAction("DDC/CI", "DDC/CI", ToggleAction.Toggle.DDCCI, true, MainAppFrame.class.getResource("resources/unchecked.jpg"), MainAppFrame.class.getResource("resources/checked.jpg"));
        filterHDCPAction = new ToggleAction("HDCP", "HDCP", ToggleAction.Toggle.HDCP, true, MainAppFrame.class.getResource("resources/unchecked.jpg"), MainAppFrame.class.getResource("resources/checked.jpg"));
        filterCECAction = new ToggleAction("CEC", "CEC", ToggleAction.Toggle.CEC, true, MainAppFrame.class.getResource("resources/unchecked.jpg"), MainAppFrame.class.getResource("resources/checked.jpg"));
        filterLTAction = new ToggleAction("LT", "LT", ToggleAction.Toggle.LT, true, MainAppFrame.class.getResource("resources/unchecked.jpg"), MainAppFrame.class.getResource("resources/checked.jpg"));
        filterEventsAction = new ToggleAction("Events", "Events", ToggleAction.Toggle.EVENTS, true, MainAppFrame.class.getResource("resources/unchecked.jpg"), MainAppFrame.class.getResource("resources/checked.jpg"));
        filterOtherAction = new ToggleAction("Others", "Others", ToggleAction.Toggle.OTHERS, true, MainAppFrame.class.getResource("resources/unchecked.jpg"), MainAppFrame.class.getResource("resources/checked.jpg"));
        errorsOnlyAction = new ToggleAction("ALL Packets", "ERRORS ONLY", ToggleAction.Toggle.ERRORSONLY, false, MainAppFrame.class.getResource("resources/yellow-off.gif"), MainAppFrame.class.getResource("resources/yellow-on.gif"));
        deltaTimeAction = new ToggleAction("DELTA mode", "CUMULATIVE mode", ToggleAction.Toggle.DELTATIME, false, MainAppFrame.class.getResource("resources/yellow-off.gif"), MainAppFrame.class.getResource("resources/yellow-on.gif"));
        enable5VoltTPAAction = new ToggleAction("Enable 5-Volt TPA", "Enable 5-Volt TPA", ToggleAction.Toggle.TPA5VOLT);
        enable5VoltTPAAction.setEnabled(false);
        enableHPDDetectionAction = new ToggleAction("Enable HPD Detection", "Enable HPD Detection", ToggleAction.Toggle.HPD_DETECTION);
        enableHPDDetectionAction.setEnabled(false);
        enablePrechargeSyncDetectionAction = new ToggleAction("Enable Precharge/Sync Detection", "Enable Precharge/Sync Detection", ToggleAction.Toggle.PRECHARGE_SYNC_DETECTION);
        enablePrechargeSyncDetectionAction.setEnabled(false);
        this.jMenuOptions.add(ComponentFactory.getCheckBoxMenuItem(enable5VoltTPAAction));
        this.jMenuOptions.add(ComponentFactory.getCheckBoxMenuItem(enableHPDDetectionAction));
        this.jMenuOptions.add(ComponentFactory.getCheckBoxMenuItem(enablePrechargeSyncDetectionAction));
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(new JMenuItem(sendCommandAction));
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(new JMenuItem(aboutAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(toggleCaptureAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(togglePauseAction));
        togglePauseAction.setEnabled(false);
        this.jToolBar.addSeparator();
        JButton jButton = new JButton(connectAction);
        jButton.setText(null);
        jButton.setToolTipText("Connect...");
        jButton.setIcon(new ImageIcon(MainAppFrame.class.getResource("resources/connect.gif")));
        this.jToolBar.add(jButton);
        jButton = new JButton(newAction);
        jButton.setText(null);
        jButton.setToolTipText("New");
        jButton.setIcon(new ImageIcon(MainAppFrame.class.getResource("resources/new.gif")));
        this.jToolBar.add(jButton);
        jButton = new JButton(openAction);
        jButton.setText(null);
        jButton.setToolTipText("Open Trace...");
        jButton.setIcon(new ImageIcon(MainAppFrame.class.getResource("resources/open.gif")));
        this.jToolBar.add(jButton);
        jButton = new JButton(saveAction);
        jButton.setText(null);
        jButton.setToolTipText("Save Trace...");
        jButton.setIcon(new ImageIcon(MainAppFrame.class.getResource("resources/save.gif")));
        this.jToolBar.add(jButton);
        this.jToolBar.addSeparator();
        this.jToolBar.add(ComponentFactory.getToggleButton(errorsOnlyAction));
        errorsOnlyAction.setEnabled(false);
        this.jToolBar.add(ComponentFactory.getToggleButton(deltaTimeAction));
        deltaTimeAction.setEnabled(false);
        this.jToolBar.addSeparator();
        openFile = null;
        try {
            files = new JFileChooser();
            files.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        }
        catch (AccessControlException accessControlException) {
            JOptionPane.showMessageDialog(Sniffer.window, "The Java Security Manager is preventing the ACA from running.");
            System.exit(1);
        }
        this.addWindowListener(new WindowHandler());
        this.updateConnectionInformation();
    }

    private boolean FoundFilterMatch(ToggleAction toggleAction) {
        boolean bl = false;
        if (toggleAction.equals(filterEDIDAction)) {
            bl = true;
        } else if (toggleAction.equals(filterDDCCIAction)) {
            bl = true;
        } else if (toggleAction.equals(filterHDCPAction)) {
            bl = true;
        } else if (toggleAction.equals(filterCECAction)) {
            bl = true;
        } else if (toggleAction.equals(filterLTAction)) {
            bl = true;
        } else if (toggleAction.equals(filterEventsAction)) {
            bl = true;
        } else if (toggleAction.equals(filterOtherAction)) {
            bl = true;
        } else if (toggleAction.equals(errorsOnlyAction)) {
            bl = true;
        } else if (toggleAction.equals(deltaTimeAction)) {
            bl = true;
        }
        return bl;
    }

    public void updateToolBar() {
        Component[] componentArray = this.jToolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ToggleAction toggleAction;
            JCheckBox jCheckBox;
            if (!(componentArray[i] instanceof JCheckBox) || !((jCheckBox = (JCheckBox)componentArray[i]).getAction() instanceof ToggleAction) || !this.FoundFilterMatch(toggleAction = (ToggleAction)jCheckBox.getAction())) continue;
            this.jToolBar.remove(jCheckBox);
        }
        if (Parser.packets.GetPacketTraceType() == PacketTraceType.HDMI_PACKET_TRACE_TYPE) {
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterEDIDAction));
            filterDDCCIAction.updateOnOffNames("DDC/CI", "DDC/CI");
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterDDCCIAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterHDCPAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterCECAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterEventsAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterOtherAction));
        } else if (Parser.packets.GetPacketTraceType() == PacketTraceType.DISPLAYPORT_PACKET_TRACE_TYPE) {
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterEDIDAction));
            filterDDCCIAction.updateOnOffNames("MCCS", "MCCS");
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterDDCCIAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterHDCPAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterLTAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterEventsAction));
            this.jToolBar.add(ComponentFactory.getCheckBoxButton(filterOtherAction));
        }
        errorsOnlyAction.setEnabled(true);
        deltaTimeAction.setEnabled(true);
        this.repaint();
    }

    void updatePortsMenus() {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        int n;
        this.jMenuDDCPort.removeAll();
        this.jMenuCECPort.removeAll();
        this.jMenuDisplayPortInterface.removeAll();
        this.buttonGroupDDCPorts = new ButtonGroup();
        this.buttonGroupCECPorts = new ButtonGroup();
        this.buttonGroupDisplayPorts = new ButtonGroup();
        if (analyzerDDCPorts != null) {
            for (n = 0; n < analyzerDDCPorts.size(); ++n) {
                jRadioButtonMenuItem = (JRadioButtonMenuItem)ComponentFactory.getRadioMenuItem(analyzerDDCPorts.get(n));
                this.buttonGroupDDCPorts.add(jRadioButtonMenuItem);
                this.jMenuDDCPort.add(jRadioButtonMenuItem);
                if (n == 0) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                analyzerDDCPort = 0;
            }
            this.jMenuDDC.setEnabled(true);
            this.jMenuDDCPort.setEnabled(true);
        } else {
            this.jMenuDDC.setEnabled(false);
            this.jMenuDDCPort.setEnabled(false);
        }
        if (analyzerCECPorts != null) {
            for (n = 0; n < analyzerCECPorts.size(); ++n) {
                jRadioButtonMenuItem = (JRadioButtonMenuItem)ComponentFactory.getRadioMenuItem(analyzerCECPorts.get(n));
                this.buttonGroupCECPorts.add(jRadioButtonMenuItem);
                this.jMenuCECPort.add(jRadioButtonMenuItem);
                if (n == 0) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                analyzerCECPort = 0;
            }
            this.jMenuCEC.setEnabled(true);
            this.jMenuCECPort.setEnabled(true);
        } else {
            this.jMenuCEC.setEnabled(false);
            this.jMenuCECPort.setEnabled(false);
        }
        if (analyzerDisplayPorts != null) {
            for (n = 0; n < analyzerDisplayPorts.size(); ++n) {
                jRadioButtonMenuItem = (JRadioButtonMenuItem)ComponentFactory.getRadioMenuItem(analyzerDisplayPorts.get(n));
                this.buttonGroupDisplayPorts.add(jRadioButtonMenuItem);
                this.jMenuDisplayPortInterface.add(jRadioButtonMenuItem);
                if (n == 0) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                analyzerDisplayPort = 0;
            }
            this.jMenuDisplayPort.setEnabled(true);
            this.jMenuDisplayPortInterface.setEnabled(true);
        } else {
            this.jMenuDisplayPort.setEnabled(false);
            this.jMenuDisplayPortInterface.setEnabled(false);
        }
    }

    public void setPauseStatus(boolean bl) {
        if (!bl) {
            Parser.packets.updateFilteredTrace();
        }
    }

    public void setCaptureStatus(boolean bl) {
        if (!bl) {
            Sniffer.parser.setCapturing(false);
            if (analyzerDDCPorts != null) {
                this.jMenuDDC.setEnabled(true);
            } else {
                this.jMenuDDC.setEnabled(false);
            }
            if (analyzerCECPorts != null) {
                this.jMenuCEC.setEnabled(true);
            } else {
                this.jMenuCEC.setEnabled(false);
            }
            if (analyzerDisplayPorts != null) {
                this.jMenuDisplayPort.setEnabled(true);
            } else {
                this.jMenuDisplayPort.setEnabled(false);
            }
            connectAction.setEnabled(true);
            newAction.setEnabled(true);
            openAction.setEnabled(true);
            togglePauseAction.setEnabled(false);
            if (Parser.packets.getPacketCount() > 0) {
                saveAction.setEnabled(true);
            }
        } else {
            Sniffer.parser.setCapturePortDDC(analyzerDDCPort);
            Sniffer.parser.setCapturePortCEC(analyzerCECPort);
            Sniffer.parser.setCaptureDisplayPort(analyzerDisplayPort);
            Sniffer.parser.setCapturing(true);
            this.jMenuDDC.setEnabled(false);
            this.jMenuCEC.setEnabled(false);
            this.jMenuDisplayPort.setEnabled(false);
            connectAction.setEnabled(false);
            newAction.setEnabled(false);
            openAction.setEnabled(false);
            togglePauseAction.setEnabled(true);
        }
    }

    public void updateConnectionInformation() {
        toggleCaptureAction.setEnabled(Parser.instrument.isConnected());
        if (Parser.instrument.isConnected()) {
            this.setStatusBar(String.format("Connected to %s: %d DDC, %d CEC, %d DisplayPort Aux Channel devices available for monitoring", Parser.connection.getName(), numDDCPorts, numCECPorts, numDisplayPorts));
        } else {
            this.setStatusBar("Not Connected");
            analyzerDDCPorts = null;
            analyzerCECPorts = null;
            analyzerDisplayPorts = null;
            enable5VoltTPAAction.setEnabled(false);
            enableHPDDetectionAction.setEnabled(false);
            enablePrechargeSyncDetectionAction.setEnabled(false);
        }
        this.updatePortsMenus();
    }

    public void setUpPacketTable() {
        int n = this.jScrollPaneTable.getWidth();
        this.jPacketTable.setModel(Parser.packets);
        this.jPacketTable.getSelectionModel().setSelectionMode(0);
        this.pl = new PacketListListener();
        this.jPacketTable.getSelectionModel().addListSelectionListener(this.pl);
        this.jPacketTable.getModel().addTableModelListener(new PacketTraceListener());
        if (Parser.packets.GetPacketTraceType() == PacketTraceType.HDMI_PACKET_TRACE_TYPE) {
            int n2 = Math.max(72, (int)(3.75 * (double)n / 100.0));
            int n3 = Math.max(36, 2 * n / 100);
            int n4 = Math.max(136, 7 * n / 100);
            int n5 = Math.max(136, 7 * n / 100);
            int n6 = Math.max(96, 5 * n / 100);
            int n7 = Math.max(120, (int)(6.25 * (double)n / 100.0));
            int n8 = Math.max(96, 5 * n / 100);
            int n9 = Math.max(96, 5 * n / 100);
            int n10 = n - (n2 + n3 + n4 + n5 + n6 + n7 + n8 + n9);
            this.jPacketTable.getColumnModel().getColumn(0).setPreferredWidth(n2);
            this.jPacketTable.getColumnModel().getColumn(1).setPreferredWidth(n3);
            this.jPacketTable.getColumnModel().getColumn(1).setResizable(false);
            this.jPacketTable.getColumnModel().getColumn(2).setPreferredWidth(n4);
            this.jPacketTable.getColumnModel().getColumn(3).setPreferredWidth(n5);
            this.jPacketTable.getColumnModel().getColumn(4).setPreferredWidth(n6);
            this.jPacketTable.getColumnModel().getColumn(5).setPreferredWidth(n7);
            this.jPacketTable.getColumnModel().getColumn(6).setPreferredWidth(n8);
            this.jPacketTable.getColumnModel().getColumn(7).setPreferredWidth(n9);
            this.jPacketTable.getColumnModel().getColumn(8).setPreferredWidth(n10);
        } else if (Parser.packets.GetPacketTraceType() == PacketTraceType.DISPLAYPORT_PACKET_TRACE_TYPE) {
            int n11 = Math.max(72, (int)(3.75 * (double)n / 100.0));
            int n12 = Math.max(128, 7 * n / 100);
            int n13 = Math.max(120, 5 * n / 100);
            int n14 = n - (n11 + n12 + n13);
            this.jPacketTable.getTableHeader().setFont(new Font("Courier New", 1, 12));
            this.jPacketTable.getColumnModel().getColumn(0).setPreferredWidth(n11);
            this.jPacketTable.getColumnModel().getColumn(1).setPreferredWidth(n12);
            this.jPacketTable.getColumnModel().getColumn(2).setPreferredWidth(n13);
            this.jPacketTable.getColumnModel().getColumn(3).setPreferredWidth(n14);
            this.jPacketTable.getColumnModel().getColumn(1).setHeaderRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JTableHeader jTableHeader;
                    if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                        this.setForeground(jTableHeader.getForeground());
                        this.setBackground(jTableHeader.getBackground());
                        this.setFont(jTableHeader.getFont());
                    }
                    this.setText(object == null ? "" : object.toString());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    this.setHorizontalAlignment(0);
                    this.setVerticalAlignment(0);
                    return this;
                }
            });
        }
        Parser.packets.refresh();
    }

    private void initComponents() {
        this.jToolBar = new JToolBar();
        this.jScrollDetails = new JScrollPane();
        this.jPacketDetails = new JTextArea();
        this.jScrollRaw = new JScrollPane();
        this.jPacketRaw = new JTextArea();
        this.jStatusBar = new JToolBar();
        this.jTextConnection = new JTextField();
        this.jTextPacketCount = new JTextField();
        this.jScrollPaneTable = new JScrollPane();
        this.jPacketTable = new JTable();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuDDC = new JMenu();
        this.jMenuDDCPort = new JMenu();
        this.jMenuCEC = new JMenu();
        this.jMenuCECPort = new JMenu();
        this.jMenuDisplayPort = new JMenu();
        this.jMenuDisplayPortInterface = new JMenu();
        this.jMenuSearch = new JMenu();
        this.jMenuOptions = new JMenu();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Quantum Data Auxiliary Channel Analyzer - Version 1.41");
        this.jToolBar.setFloatable(false);
        this.jToolBar.setMaximumSize(new Dimension(13, 32));
        this.jToolBar.setMinimumSize(new Dimension(13, 32));
        this.jToolBar.setPreferredSize(new Dimension(13, 32));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.jToolBar, gridBagConstraints);
        this.jScrollDetails.setBorder(new TitledBorder("Details"));
        this.jScrollDetails.setMinimumSize(new Dimension(37, 75));
        this.jScrollDetails.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPacketDetails.setEditable(false);
        this.jPacketDetails.setFont(new Font("Monospaced", 0, 12));
        this.jPacketDetails.setLineWrap(true);
        this.jPacketDetails.setWrapStyleWord(true);
        this.jScrollDetails.setViewportView(this.jPacketDetails);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 60.0;
        gridBagConstraints.weighty = 30.0;
        this.getContentPane().add((Component)this.jScrollDetails, gridBagConstraints);
        this.jScrollRaw.setBorder(new TitledBorder("Data"));
        this.jScrollRaw.setMinimumSize(new Dimension(37, 75));
        this.jScrollRaw.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPacketRaw.setEditable(false);
        this.jPacketRaw.setFont(new Font("Monospaced", 0, 12));
        this.jScrollRaw.setViewportView(this.jPacketRaw);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 40.0;
        gridBagConstraints.weighty = 30.0;
        this.getContentPane().add((Component)this.jScrollRaw, gridBagConstraints);
        this.jStatusBar.setFloatable(false);
        this.jStatusBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
        this.jStatusBar.setMinimumSize(new Dimension(13, 28));
        this.jStatusBar.setPreferredSize(new Dimension(13, 28));
        this.jTextConnection.setEditable(false);
        this.jTextConnection.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        this.jTextConnection.setFocusable(false);
        this.jTextConnection.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        this.jTextConnection.setMinimumSize(new Dimension(8, 24));
        this.jTextConnection.setPreferredSize(new Dimension(93, 24));
        this.jStatusBar.add(this.jTextConnection);
        this.jTextPacketCount.setEditable(false);
        this.jTextPacketCount.setHorizontalAlignment(4);
        this.jTextPacketCount.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        this.jTextPacketCount.setFocusable(false);
        this.jTextPacketCount.setMaximumSize(new Dimension(192, 24));
        this.jTextPacketCount.setMinimumSize(new Dimension(192, 24));
        this.jTextPacketCount.setPreferredSize(new Dimension(192, 24));
        this.jStatusBar.add(this.jTextPacketCount);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 5.0;
        this.getContentPane().add((Component)this.jStatusBar, gridBagConstraints);
        this.jScrollPaneTable.setBorder(new TitledBorder("Packets"));
        this.jPacketTable.setFont(new Font("Monospaced", 1, 12));
        this.jPacketTable.setAutoResizeMode(3);
        this.jScrollPaneTable.setViewportView(this.jPacketTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 60.0;
        this.getContentPane().add((Component)this.jScrollPaneTable, gridBagConstraints);
        this.jMenuBar.setBorder(null);
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuDDC.setMnemonic('D');
        this.jMenuDDC.setText("DDC");
        this.jMenuDDC.setEnabled(false);
        this.jMenuDDCPort.setMnemonic('P');
        this.jMenuDDCPort.setText("Port");
        this.jMenuDDCPort.setEnabled(false);
        this.jMenuDDC.add(this.jMenuDDCPort);
        this.jMenuBar.add(this.jMenuDDC);
        this.jMenuCEC.setMnemonic('C');
        this.jMenuCEC.setText("CEC");
        this.jMenuCEC.setEnabled(false);
        this.jMenuCECPort.setMnemonic('P');
        this.jMenuCECPort.setText("Port");
        this.jMenuCECPort.setEnabled(false);
        this.jMenuCEC.add(this.jMenuCECPort);
        this.jMenuBar.add(this.jMenuCEC);
        this.jMenuDisplayPort.setMnemonic('P');
        this.jMenuDisplayPort.setText("DisplayPort");
        this.jMenuDisplayPort.setEnabled(false);
        this.jMenuDisplayPortInterface.setMnemonic('P');
        this.jMenuDisplayPortInterface.setText("Port");
        this.jMenuDisplayPortInterface.setEnabled(false);
        this.jMenuDisplayPort.add(this.jMenuDisplayPortInterface);
        this.jMenuBar.add(this.jMenuDisplayPort);
        this.jMenuSearch.setMnemonic('S');
        this.jMenuSearch.setText("Search");
        this.jMenuBar.add(this.jMenuSearch);
        this.jMenuOptions.setMnemonic('O');
        this.jMenuOptions.setText("Options");
        this.jMenuBar.add(this.jMenuOptions);
        this.setJMenuBar(this.jMenuBar);
    }

    public static File ShowOpenFileDialog(String string, String string2, String string3) {
        File file = null;
        files.setAccessory(null);
        files.setDialogTitle(string);
        files.setApproveButtonText(string2);
        files.setApproveButtonToolTipText(string3);
        files.setFileSelectionMode(0);
        files.resetChoosableFileFilters();
        files.rescanCurrentDirectory();
        String string4 = ".BMtrace";
        String string5 = "Bus Monitor Trace Files (" + string4 + ")";
        files.setFileFilter(new ExtensionFilter(string4, string5));
        files.setSelectedFile(new File("default" + string4));
        int n = -1;
        try {
            n = files.showOpenDialog(Sniffer.window);
        }
        catch (Exception exception) {
            n = files.showOpenDialog(Sniffer.window);
        }
        if (n == 0) {
            file = files.getSelectedFile();
        }
        return file;
    }

    public static File ShowSaveFileDialog(String string, String string2, String string3) {
        File file = null;
        TraceFileFormatAccessory traceFileFormatAccessory = new TraceFileFormatAccessory(files);
        files.setAccessory(traceFileFormatAccessory);
        files.setDialogTitle(string);
        files.setApproveButtonText(string2);
        files.setApproveButtonToolTipText(string3);
        files.setFileSelectionMode(0);
        files.resetChoosableFileFilters();
        files.rescanCurrentDirectory();
        traceFileFormatAccessory.setNewFileFilter();
        files.setSelectedFile(openFile);
        int n = files.showSaveDialog(Sniffer.window);
        if (n == 0) {
            file = files.getSelectedFile();
            String string4 = file.getName().toLowerCase();
            switch (traceFileFormatAccessory.GetFileFormatType()) {
                case HTML: {
                    if (string4.endsWith(".html")) break;
                    if (string4.endsWith(".htm")) {
                        String string5 = string4 + "l";
                        file = new File(string5);
                        break;
                    }
                    String string6 = file.getAbsolutePath() + ".html";
                    file = new File(string6);
                    break;
                }
                case TEXT: {
                    if (string4.endsWith(".txt")) break;
                    String string7 = file.getAbsolutePath() + ".txt";
                    file = new File(string7);
                    break;
                }
                case EDID: {
                    if (string4.endsWith(".xml")) break;
                    String string8 = file.getAbsolutePath() + ".xml";
                    file = new File(string8);
                    break;
                }
                default: {
                    if (string4.endsWith(".bmtrace")) break;
                    String string9 = file.getAbsolutePath() + ".BMtrace";
                    file = new File(string9);
                }
            }
        }
        return file;
    }

    ListSelectionModel getTableSelectionModel() {
        return this.jPacketTable.getSelectionModel();
    }

    JScrollPane getTableScrollPane() {
        return this.jScrollPaneTable;
    }

    JTable getTable() {
        return this.jPacketTable;
    }

    public void setStatusBar(String string) {
        this.jTextConnection.setText(string);
    }

    static String getTraceFilename() {
        String string = "default.BMtrace";
        return string;
    }

    static String getCurrentTraceFilename() {
        return openFile.getName();
    }

    void updateTitleBarText() {
        String string = "Quantum Data Auxiliary Channel Analyzer - Version 1.41";
        if (openFile != null) {
            string = string + " - " + openFile.getName();
        }
        this.setTitle(string);
    }

    static String getHtmlFilename() {
        String string = "default.html";
        return string;
    }

    public void saveToHTML(File file) {
        StringBuffer stringBuffer = Parser.packets.saveToHtml();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.getParent(), "Error writing report to selected file");
        }
    }

    public void updateTimeColumnName() {
        Parser.packets.updateTimeColumnName(this.jPacketTable);
        this.jPacketTable.getTableHeader().resizeAndRepaint();
    }

    public void updateTimeColumnData() {
        this.updateTimeColumnName();
        ListSelectionModel listSelectionModel = this.getTableSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            this.jPacketDetails.setText("No packets selected.");
            this.jPacketRaw.setText("");
            this.jPacketDetails.setCaretPosition(0);
            this.jPacketRaw.setCaretPosition(0);
            if (deltaTimeAction.isTrue()) {
                listSelectionModel.removeListSelectionListener(this.pl);
                Parser.packets.refresh();
                listSelectionModel.addListSelectionListener(this.pl);
            } else {
                Parser.packets.refresh();
            }
        } else {
            selectedRow = listSelectionModel.getLeadSelectionIndex();
            Packet packet = Parser.packets.getPacket(selectedRow);
            this.jPacketDetails.setText(packet.getExtendedDetails());
            this.jPacketDetails.setCaretPosition(0);
            this.jPacketRaw.setText(packet.getHex());
            this.jPacketRaw.setCaretPosition(0);
            if (deltaTimeAction.isTrue()) {
                listSelectionModel.removeListSelectionListener(this.pl);
                Parser.packets.refresh();
                listSelectionModel.addListSelectionListener(this.pl);
            } else {
                Parser.packets.refresh();
            }
            this.jPacketTable.addRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    public static void scrollToVisible(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    public static String getTextFilename() {
        return "default.txt";
    }

    public void saveToText(File file) {
        int n;
        int n2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\r\n" + String.format("%1$24s", "ACA Program Version:  ") + 1 + "." + 41 + "\r\n");
        if (Parser.instrument.isConnected()) {
            object = "verf?";
            String string = Parser.instrument.sendCmd((String)object).getResponse();
            String string2 = "verg?";
            String string3 = Parser.instrument.sendCmd(string2).getResponse();
            if (string != null) {
                stringBuffer.append(String.format("%1$24s", "Firmware Version:  ") + string + "\r\n");
            } else {
                stringBuffer.append("   Firmware Version:  Unable to Acquire From Generator @ " + Parser.instrument.getConnection().getName() + "\r\n\r\n");
            }
            if (string3 != null) {
                stringBuffer.append(String.format("%1$24s", "Gateware Version:  ") + string3 + "\r\n\r\n\r\n");
            } else {
                stringBuffer.append("   Gateware Version:  Unable to Acquire From Generator @ " + Parser.instrument.getConnection().getName() + "\r\n\r\n");
            }
        }
        stringBuffer.append("\r\n");
        object = Parser.packets;
        int n3 = ((PacketTrace)object).getColumnCount();
        int n4 = ((PacketTrace)object).getRowCount();
        int n5 = 3;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            n = ((PacketTrace)object).getNonHtmlColumnName(n2).length();
            nArray[n2] = n > nArray[n2] ? n : nArray[n2];
            nArray2[n2] = n;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n6 = ((String)((PacketTrace)object).getValueAt(n2, n, true)).length();
                nArray[n] = n6 > nArray[n] ? n6 : nArray[n];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            String string = ((PacketTrace)object).getNonHtmlColumnName(n2);
            stringBuffer.append(string + MainAppFrame.MakeSpaceString(nArray[n2] + n5 - string.length()));
        }
        stringBuffer.append("Raw data\r\n");
        for (n2 = 0; n2 < n3; ++n2) {
            String string = MainAppFrame.MakeDashedLineString(nArray2[n2]);
            stringBuffer.append(string + MainAppFrame.MakeSpaceString(nArray[n2] + n5 - string.length()));
        }
        stringBuffer.append("--------\r\n");
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n3; ++i) {
                String string = (String)((PacketTrace)object).getValueAt(n2, i, true);
                stringBuffer.append(string.toString() + MainAppFrame.MakeSpaceString(nArray[i] + n5 - string.length()));
            }
            Packet packet = Parser.packets.getPacket(n2);
            stringBuffer.append(packet.getHexString() + "\r\n");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.getParent(), "Error writing report to selected file");
        }
    }

    public static String MakeSpaceString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String MakeDashedLineString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public void setTraceToBeginning() {
        this.jPacketTable.scrollRectToVisible(this.jPacketTable.getCellRect(0, 0, true));
    }

    static {
        selectedRow = -1;
        numDDCPorts = 0;
        numCECPorts = 0;
        numDisplayPorts = 0;
    }

    private class PacketListListener
    implements ListSelectionListener {
        private PacketListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                MainAppFrame.this.jPacketDetails.setText("No packets selected.");
                MainAppFrame.this.jPacketRaw.setText("");
            } else {
                selectedRow = listSelectionModel.getLeadSelectionIndex();
                Packet packet = Parser.packets.getPacket(selectedRow);
                MainAppFrame.this.jPacketDetails.setText(packet.getExtendedDetails());
                MainAppFrame.this.jPacketDetails.setCaretPosition(0);
                MainAppFrame.this.jPacketRaw.setText(packet.getHex());
                MainAppFrame.this.jPacketRaw.setCaretPosition(0);
                if (deltaTimeAction.isTrue()) {
                    listSelectionModel.removeListSelectionListener(this);
                    Parser.packets.refresh();
                    MainAppFrame.this.jPacketTable.addRowSelectionInterval(selectedRow, selectedRow);
                    listSelectionModel.addListSelectionListener(this);
                } else {
                    MainAppFrame.this.jPacketTable.addRowSelectionInterval(selectedRow, selectedRow);
                }
            }
        }
    }

    private class PacketTraceListener
    implements TableModelListener {
        private PacketTraceListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            MainAppFrame.this.jTextPacketCount.setText(Parser.packets.getPacketCount() + " packets (" + Parser.packets.getFilteredCount() + " shown)");
            if (Sniffer.parser.isCapturing()) {
                MainAppFrame.this.jPacketTable.scrollRectToVisible(MainAppFrame.this.jPacketTable.getCellRect(MainAppFrame.this.jPacketTable.getRowCount() - 1, 0, true));
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (confirmExitAction.isTrue() && Parser.packets.needsSaving()) {
                saveAsAction.save();
            }
            System.exit(0);
        }
    }
}

